<?php

namespace App\Classes\Sales;
use App\Models\POS\NoticeCreditor;
use App\Models\Sales\SalesInvoice;
use App\Models\Main\Setting;
use App\Models\Main\Branch;
use App\Classes\Finance\DailyJournalHelper;
use App\Models\Finance\DailyJournal;


use DB;
use Http;
class NoticeCreditorHelper
{
    

    function generate_daily_journal($id){

        $check = Setting::get_main_setting_by_code('notice_creditor_journal')->value ?? false ;
        if(!$check){
            return array( true ,  '' ) ;
        }


        $master     = NoticeCreditor::get_notice_creditor_m($id, 'en');
        $details    = NoticeCreditor::get_notice_creditor_d($id, 'en');
        $payments   = NoticeCreditor::get_payments( $id ,'en' );

        if(!isset($master->active) || $master->active == 0 ){
            DailyJournal::delete_daily_journal_m($master->daily_journal_m_id);
            return array( true ,  '' ) ;
        }


        $items      = [];
        $journal_data  = array(
            'finance_year_id'   => $master->finance_year_id  ,
            'branch_id'         => $master->branch_id ,
            'des'               => $master->description ?? 'اشعار دائن رقم '.$id ,
            'journal_date'      => $master->invoice_date ,
            'document_id'       => $id ,
            'daily_type_id'     => 33 ,
            'auto_generated'    => 1 ,
            'journal_active'    => 1 ,
            'confirmed'         => 1
        );

        if($master->daily_journal_m_id > 0 ){
            $journal_data['daily_journal_id'] = $master->daily_journal_m_id;
        }


        switch ($master->sales_invoice_type_id) {
            case '1':
               $items[]   = array(
                    'account_tree_id'   => $master->customer_account_tree_id ,
                    'cost_center_id'    => 0 ,
                    'credit'            => collect($details)->sum('new_total_with_vat') ,
                    'debit'             => 0 ,
                    'description'       => $master->description ?? 'اشعار دائن رقم '.$id
                );
            break;
            case '2':
                $items[]   = array(
                    'account_tree_id'   => $master->treasury_account_tree_id ,
                    'cost_center_id'    => 0 ,
                    'credit'            => collect($details)->sum('new_total_with_vat') ,
                    'debit'             =>  0 ,
                    'description'       => $master->description ?? 'اشعار دائن رقم '.$id
                );
            break;
            case '3':
                $items[]   = array(
                    'account_tree_id'   => $master->machine_account_tree_id ,
                    'cost_center_id'    => 0 ,
                    'credit'            => collect($details)->sum('new_total_with_vat')   ,
                    'debit'             =>  0 ,
                    'description'       => $master->description ?? 'اشعار دائن رقم '.$id
                );
            break;
            case '4':
                
                $items[]   = array(
                    'account_tree_id'   => $master->treasury_account_tree_id ,
                    'cost_center_id'    => 0 ,
                    'credit'            => collect($payments)->where('payment_type' , 1)->sum('amount')    ,
                    'debit'             =>  0 ,
                    'description'       => $master->description ?? 'اشعار دائن رقم '.$id
                );

                $items[]   = array(
                    'account_tree_id'   => $master->machine_account_tree_id ,
                    'cost_center_id'    => 0 ,
                    'credit'            => collect($payments)->where('payment_type' , 2)->sum('amount')   ,
                    'debit'             =>  0 ,
                    'description'       => $master->description ?? 'اشعار دائن رقم '.$id
                );

            break;
        }


        foreach ( $details as $key => $detail ) {

            $items[]    = array(
                'account_tree_id'   => $detail->sales_return_id ?? 0 ,
                'cost_center_id'    => 0 ,
                'debit'             => $detail->new_total_without_vat ,
                'credit'            => 0 ,
                'description'       => $master->description ?? 'اشعار دائن رقم '.$id
            );

            $items[]    = array(
                'account_tree_id'   => $detail->tax_account_tree_id ?? 0 ,
                'cost_center_id'    => 0 ,
                'debit'             => $detail->new_total_vat ,
                'credit'            => 0 ,
                'description'       => $master->description ?? 'اشعار دائن رقم '.$id
            );

        }


        $journal = (new DailyJournalHelper)->generate_journal($journal_data , $items );

        if($journal[0]){
            
            DB::table('notice_creditors_m')
                    ->where('notice_creditor_m_id' , $id)
                    ->update( ['daily_journal_m_id' => $journal[2]] );
            return $journal;

        }else{

            $response = [
               'check' => false,
               'data'  => $journal ,
               'msg'   => $journal[1]
            ];
            header('Content-Type: application/json; charset=utf-8; ');
            header('Access-Control-Allow-Origin:*');
            header('Access-Control-Allow-Headers:*');
            echo json_encode($response);
            die();

        }


    }

    function send_zatca($invoice)
    {
        $data = check_third_app('zatca_integration');
        if (!$data['check'])
            return false;
        $data['app_data']   = json_decode($data['app_data'] , true);
        $last               = NoticeCreditor::get_notice_creditor_m(($invoice - 1), 'en');
        $master             = NoticeCreditor::get_notice_creditor_m($invoice, 'en');
        $details            = NoticeCreditor::get_notice_creditor_d($invoice, 'en');
        $branch             = Branch::get_branch($master->branch_id, 'en');
        $last_hash          = (!isset($last->notice_hash) || strlen($last->notice_hash) < 10 ? "NWZlY2ViNjZmZmM4NmYzOGQ5NTI3ODZjNmQ2OTZjNzljMmRiYzIzOWRkNGU5MWI0NjcyOWQ3M2EyN2ZiNTdlOQ==" : $last->notice_hash);
        $invoice_type       = (!isset($master->sales_invoice_type_id) || $master->sales_invoice_type_id == 1 ? "0100000" : "0200000");
        $token              = $data['app_data'][$data['env']]['token'] ?? '';
        $header = [
            "Accept"        => "application/json",
            "Content-Type"  => "application/json",
            "Token"         => $token
        ];
        $body = [
            "id" => $invoice,
            "currency" => "SAR",
            "invoice_date" => $master->invoice_date,
            "invoice_time" => date("H:i:s", strtotime($master->add_date)),
            "uuid" => $master->notice_uuid,
            "invoice_type_code" => "381",
            "invoice_type_code_name" => $invoice_type,
            'reason'    => 'notice credit' ,
            'related_sales_invoice' => "Invoice Number: ".$master->sales_invoice_m_id."; Invoice Issue Date: ".$master->invoice_date ,
            "pih" => $last_hash,
            "reference_id" => 0,
            "return_reson" => "reson",
            "totals" => [
                'total_vat' => collect($details)->sum('new_total_vat'),
                'total_without_vat' => collect($details)->sum('new_total_without_vat') ,
                'total_with_vat' => collect($details)->sum('new_total_with_vat'),
                'discount' => 0,
                'total_taxble' => collect($details)->where('new_total_vat', '>', 0)->sum('new_total_without_vat'),
                'percent' => "15.00"
            ],
            "supplier_info" => [
                "crn" => "311111111111113",
                "vat_number" => $branch->vat_number,
                "vat_register_name" => $branch->vat_register_name,
                "address" => [
                    "streetName" => "testA",
                    "buildingNumber" => "1234",
                    "plotIdentification" => "1234",
                    "citySubdivisionName" => "R",
                    "cityName" => "Dammam",
                    "postalZone" => "12345",
                    "countrySubentity" => "Test",
                    "country" => "SA"
                ]
            ],
            "customerInfo" => [
                "nat" => "2345",
                "vat_number" => $master->customer_vat_register_number,
                "vat_register_name" => $master->customer_name,
                "address" => [
                    "streetName" => $master->address,
                    "buildingNumber" => "3353",
                    "plotIdentification" => "1234",
                    "citySubdivisionName" => "R",
                    "cityName" => "Dammam",
                    "postalZone" => "12345",
                    "countrySubentity" => "Test",
                    "country" => "SA"
                ]
            ],
            "invoiceLineItem" => [],
        ];


        foreach ($details as $key => $row) {

            $body['invoiceLineItem'][] = [
                "id" => (string)$row->d_id,
                "qty" => $row->new_quantity,
                "name" => ($row->item_name ),
                "total_vat" => $row->new_total_vat,
                "total_without_vat" => $row->new_total_without_vat,
                "total_with_vat" => $row->new_total_with_vat,
                "tax_code" => $row->zatca_code,
                "tax_scheme" => "VAT",
                "tax_percent" => $row->tax_percent
            ];
        }

        $result = Http::withHeaders($header)->post("https://sallawebhook.qaraterp.com/api/v1/send_invoice", $body);
        $result = json_decode($result->body() , true);



        if(isset($result['success']) &&  $result['success']){

            DB::table('notice_creditors_m')
                ->where('notice_creditor_m_id' , $invoice)
                ->update([
                    'notice_hash'  => $result['hash'] ,
                    'notice_qrcode'=> $result['qr']
                ]);

        }else{
            $response = [
                'check' => false,
                'data'  => $result ,
                'msg'   => 'error in zatca'
            ];
            header('Content-Type: application/json; charset=utf-8; ');
            header('Access-Control-Allow-Origin:*');
            header('Access-Control-Allow-Headers:*');
            echo json_encode($response);
            die();
        }


        return true;
    }

}
