<?php

namespace App\Classes\Sales;

use DB;

class DailyReportHelper
{

   function get_daily_report($params){
        $query_item_sales = DB::table('sales_invoice_d')
            ->leftjoin('sales_invoice_m' , 'sales_invoice_m.sales_invoice_m_id' , '=' , 'sales_invoice_d.sales_invoice_m_id')
            ->leftjoin('items' , 'items.item_id' , '=' , 'sales_invoice_d.item_id')
            ->leftjoin('item_types' , 'items.item_type_id' , '=' , 'item_types.item_type_id')
            ->leftjoin('sales_invoice_types' , 'sales_invoice_m.sales_invoice_type_id' , '=' , 'sales_invoice_types.sales_invoice_type_id')
            ->leftjoin('sales_invoice_payments', 'sales_invoice_m.sales_invoice_m_id' , '=' , 'sales_invoice_payments.sales_invoice_m_id')
            ->leftjoin('payment_methods', 'sales_invoice_payments.payment_type' , '=' , 'payment_methods.payment_method_id')
            ->where('sales_invoice_m.sales_invoice_date' , '=' , $params['date'])
            ->where('sales_invoice_active' , '=' , 1)
            ->groupBy('item_types.item_type_id')
            ->selectRaw('
                item_types.item_type_id,
                item_types.name_'.$params['lang'].' as item_type,
                sum(sales_invoice_d.total_with_vat) as item_sales
            ');
        if(isset($params['branch_id'])){
            $query_item_sales->where('sales_invoice_m.branch_id',$params['branch_id']);
        }
        if(isset($params['treasury_id'])){
            $query_item_sales->where('sales_invoice_payments.treasury_id',$params['treasury_id']);
        }
        $item_sales =  $query_item_sales->get()->groupBy('item_type');

        $query_sales = DB::table('sales_invoice_m')
            ->leftjoin('sales_invoice_types' , 'sales_invoice_m.sales_invoice_type_id' , '=' , 'sales_invoice_types.sales_invoice_type_id')
            ->leftjoin('sales_invoice_payments', 'sales_invoice_m.sales_invoice_m_id' , '=' , 'sales_invoice_payments.sales_invoice_m_id')
            ->leftjoin('payment_methods', 'sales_invoice_payments.payment_type' , '=' , 'payment_methods.payment_method_id')
            ->where('sales_invoice_m.sales_invoice_date' , '=' , $params['date'])
            ->where('sales_invoice_active' , '=' , 1)
            ->selectRaw('
                sales_invoice_m.sales_invoice_date,
                sum(case when sales_invoice_types.sales_invoice_type_id = 1 then (sales_invoice_m.total_with_vat) end) as term_sales,
                sum(case when sales_invoice_payments.payment_type = 1 then
                    case when sales_invoice_payments.treasury_id = ? then sales_invoice_payments.amount else 0 end
                    end) as paid_cash,
                sum(case when sales_invoice_payments.payment_type = 2 then sales_invoice_payments.amount end) as paid_bank,
                sum(case when sales_invoice_payments.payment_type = 3 then sales_invoice_payments.amount end) as paid_trans
            ', [$params['treasury_id'] ?? null]);
        if(isset($params['branch_id'])){
            $query_item_sales->where('sales_invoice_m.branch_id',$params['branch_id']);
        }

        $sales =  $query_sales->first();

        $all_notice_creditors = DB::table('notice_creditors_m')
            ->leftjoin('notice_creditors_d' , 'notice_creditors_m.notice_creditor_m_id' , '=' , 'notice_creditors_d.notice_creditor_m_id')
            ->selectRaw('notice_creditors_m.notice_creditor_m_id , sum(notice_creditors_d.new_total_with_vat) as total')
            ->groupBy('notice_creditors_m.notice_creditor_m_id');


        $query_n_creditor = DB::table('notice_creditors_m')

            ->joinSub($all_notice_creditors, 'all_notice_creditors', function ($join) {
                $join->on('notice_creditors_m.notice_creditor_m_id', '=', 'all_notice_creditors.notice_creditor_m_id');
            })
            ->leftjoin('notice_payments' , 'notice_creditors_m.notice_creditor_m_id' , '=' , 'notice_payments.notice_creditor_m_id')
            ->leftjoin('sales_invoice_m' , 'notice_creditors_m.sales_invoice_m_id' , '=' , 'sales_invoice_m.sales_invoice_m_id')
            ->leftjoin('sales_invoice_types' , 'sales_invoice_m.sales_invoice_type_id' , '=' , 'sales_invoice_types.sales_invoice_type_id')
            ->where('notice_creditors_m.invoice_date' , '=' , $params['date'] )
            ->where('notice_creditor_active' , '=' , 1)
            ->groupBy('notice_creditors_m.notice_creditor_m_id')
            ->selectRaw('
                notice_creditors_m.invoice_date ,
                if(sales_invoice_m.sales_invoice_type_id = 1 , all_notice_creditors.total , 0 ) as term_sales ,
                sum(case when notice_payments.payment_type = 1 then
                    case when notice_creditors_m.treasury_id = ? then notice_payments.amount else 0 end
                    end) as paid_cash,
                sum( case when notice_payments.payment_type = 2 then notice_payments.amount end ) as paid_bank ,
                sum( case when notice_payments.payment_type = 3 then notice_payments.amount end ) as paid_trans
            ', [$params['treasury_id'] ?? null]);
        if(isset($params['branch_id'])){
            $query_item_sales->where('notice_creditors_m.branch_id',$params['branch_id']);
        }

        $all_n_creditor = $query_n_creditor->get();

        $n_creditor = [
            'term_sales'    => collect($all_n_creditor)->sum('term_sales') ,
            'paid_cash'     => collect($all_n_creditor)->sum('paid_cash') ,
            'paid_bank'     => collect($all_n_creditor)->sum('paid_bank') ,
            'paid_trans'    => collect($all_n_creditor)->sum('paid_trans') ,
        ];


        $query_reciept_vouchers = DB::table('receipt_vouchers')
            ->where('receipt_vouchers.action_date' ,  $params['date'] )
            ->where('receipt_voucher_active' , 1)
            ->where('receipt_vouchers.to_type' , 2);

        if(isset($params['branch_id'])){
            $query_item_sales->where('receipt_vouchers.branch_id',$params['branch_id']);
        }
        if(isset($params['treasury_id'])){
            $query_reciept_vouchers->where('receipt_vouchers.to_treasury_id',$params['treasury_id']);
        }
        $reciept_vouchers= $query_reciept_vouchers->sum('amount');

        $query_payment_vouchers = DB::table('payment_vouchers')
            ->where('payment_vouchers.action_date' ,  $params['date'] )
            ->where('payment_voucher_active' , 1)
            ->where('payment_vouchers.from_type' , 2);

        if(isset($params['branch_id'])){
            $query_item_sales->where('payment_vouchers.branch_id',$params['branch_id']);
        }
        if(isset($params['treasury_id'])){
            $query_payment_vouchers->where('payment_vouchers.from_treasury_id',$params['treasury_id']);
        }
        $payment_vouchers = $query_payment_vouchers->sum('amount');

        $query_multi_vouchers = DB::table('multi_voucher_d')
            ->leftjoin('multi_voucher_m' , 'multi_voucher_d.multi_voucher_m_id' , '=' , 'multi_voucher_m.multi_voucher_m_id')
            ->where('multi_voucher_d.dis_type' , '=' , 1 )
            ->where('multi_voucher_m.action_date' , '=' , $params['date'] )
            ->where('multi_voucher_d_active' , '=' , 1)
            ->where('multi_voucher_active' , '=' , 1)
            ->selectRaw('
                multi_voucher_m.action_date ,
                sum( case when multi_voucher_d.voucher_type = 2 then multi_voucher_d.amount end ) as credit,
                sum( case when multi_voucher_d.voucher_type = 1 then multi_voucher_d.amount end ) as debit
            ');

        if(isset($params['branch_id'])){
            $query_item_sales->where('multi_voucher_m.branch_id' , $params['branch_id']);
        }
        if(isset($params['treasury_id'])){
            $query_multi_vouchers->where('multi_voucher_d.dis_treasury_id',$params['treasury_id']);
        }
        $multi_vouchers = $query_multi_vouchers->first();

        $report = [
            'item_sales'            => $item_sales,
            'sales'                 => $sales,
            'creditor'              => $n_creditor,
            'reciepts'              => $reciept_vouchers,
            'payments'              => $payment_vouchers,
            'credit_adjustments'    => $multi_vouchers->credit,
            'debit_adjustments'     => $multi_vouchers->debit,
            'first'                 => $params['first']
        ];

        return $report;

    }

    
    function get_full_daily_report($params){

        $query_sales = DB::table('sales_invoice_m')
            ->leftjoin('sales_invoice_types' , 'sales_invoice_m.sales_invoice_type_id' , '=' , 'sales_invoice_types.sales_invoice_type_id')
            ->leftjoin('sales_invoice_payments', 'sales_invoice_m.sales_invoice_m_id' , '=' , 'sales_invoice_payments.sales_invoice_m_id')
            ->leftjoin('payment_methods', 'sales_invoice_payments.payment_type' , '=' , 'payment_methods.payment_method_id')
            ->where('sales_invoice_m.sales_invoice_date' , '=' , $params['date'])
            ->where('sales_invoice_active' , '=' , 1)
            ->selectRaw('
                sales_invoice_m.sales_invoice_date,
                sum(case when sales_invoice_types.sales_invoice_type_id = 1 then (sales_invoice_m.total_with_vat) end) as term_sales,
                sum(case when sales_invoice_payments.payment_type = 1 then
                    case when sales_invoice_payments.treasury_id = ? then sales_invoice_payments.amount else 0 end
                    end) as paid_cash,
                sum(case when sales_invoice_payments.payment_type = 2 then sales_invoice_payments.amount end) as paid_bank,
                sum(case when sales_invoice_payments.payment_type = 3 then sales_invoice_payments.amount end) as paid_trans
            ', [$params['treasury_id'] ?? null]);
        if(isset($params['branch_id'])){
            $query_sales->where('sales_invoice_m.branch_id',$params['branch_id']);
        }

        $sales =  $query_sales->first();

        $all_notice_creditors = DB::table('notice_creditors_m')
            ->leftjoin('notice_creditors_d' , 'notice_creditors_m.notice_creditor_m_id' , '=' , 'notice_creditors_d.notice_creditor_m_id')
            ->selectRaw('notice_creditors_m.notice_creditor_m_id , sum(notice_creditors_d.new_total_with_vat) as total')
            ->groupBy('notice_creditors_m.notice_creditor_m_id');


        $query_n_creditor = DB::table('notice_creditors_m')

            ->joinSub($all_notice_creditors, 'all_notice_creditors', function ($join) {
                $join->on('notice_creditors_m.notice_creditor_m_id', '=', 'all_notice_creditors.notice_creditor_m_id');
            })
            ->leftjoin('notice_payments' , 'notice_creditors_m.notice_creditor_m_id' , '=' , 'notice_payments.notice_creditor_m_id')
            ->leftjoin('sales_invoice_m' , 'notice_creditors_m.sales_invoice_m_id' , '=' , 'sales_invoice_m.sales_invoice_m_id')
            ->leftjoin('sales_invoice_types' , 'sales_invoice_m.sales_invoice_type_id' , '=' , 'sales_invoice_types.sales_invoice_type_id')
            ->where('notice_creditors_m.invoice_date' , '=' , $params['date'] )
            ->where('notice_creditor_active' , '=' , 1)
            ->groupBy('notice_creditors_m.notice_creditor_m_id')
            ->selectRaw('
                notice_creditors_m.invoice_date ,
                if(sales_invoice_m.sales_invoice_type_id = 1 , all_notice_creditors.total , 0 ) as term_sales ,
                sum(case when notice_payments.payment_type = 1 then
                    case when notice_creditors_m.treasury_id = ? then notice_payments.amount else 0 end
                    end) as paid_cash,
                sum( case when notice_payments.payment_type = 2 then notice_payments.amount end ) as paid_bank ,
                sum( case when notice_payments.payment_type = 3 then notice_payments.amount end ) as paid_trans
            ', [$params['treasury_id'] ?? null]);
        if(isset($params['branch_id'])){
            $query_n_creditor->where('notice_creditors_m.branch_id',$params['branch_id']);
        }

        $all_n_creditor = $query_n_creditor->get();

        $n_creditor = [
            'term_sales'    => collect($all_n_creditor)->sum('term_sales') ,
            'paid_cash'     => collect($all_n_creditor)->sum('paid_cash') ,
            'paid_bank'     => collect($all_n_creditor)->sum('paid_bank') ,
            'paid_trans'    => collect($all_n_creditor)->sum('paid_trans') ,
        ];

        $query_purchases = DB::table('purchases_invoice_m')
            ->where('purchases_invoice_m.purchases_invoice_date' , '=' , $params['date'])
            ->where('purchases_invoice_active' , '=' , 1)
            ->selectRaw('
                purchases_invoice_m.purchases_invoice_date,
                sum(case when purchases_invoice_m.purchases_invoice_type_id = 1 then (purchases_invoice_m.total_with_vat) end) as term_purchase,
                sum(case when purchases_invoice_m.purchases_invoice_type_id = 2 then (purchases_invoice_m.total_with_vat) end) as paid_cash
            ');
            if(isset($params['branch_id'])){
                $query_purchases->where('purchases_invoice_m.branch_id',$params['branch_id']);
            }

        $purchases =  $query_purchases->first();

        $query_reciept_vouchers = DB::table('receipt_vouchers')
            ->where('receipt_vouchers.action_date' ,  $params['date'] )
            ->where('receipt_voucher_active' , 1)
            ->where('receipt_vouchers.to_type' , 2);

        if(isset($params['branch_id'])){
            $query_reciept_vouchers->where('receipt_vouchers.branch_id',$params['branch_id']);
        }
        if(isset($params['treasury_id'])){
            $query_reciept_vouchers->where('receipt_vouchers.to_treasury_id',$params['treasury_id']);
        }
        $reciept_vouchers= $query_reciept_vouchers->sum('amount');

        $query_payment_vouchers = DB::table('payment_vouchers')
            ->where('payment_vouchers.action_date' ,  $params['date'] )
            ->where('payment_voucher_active' , 1)
            ->where('payment_vouchers.from_type' , 2);

        if(isset($params['branch_id'])){
            $query_payment_vouchers->where('payment_vouchers.branch_id',$params['branch_id']);
        }
        if(isset($params['treasury_id'])){
            $query_payment_vouchers->where('payment_vouchers.from_treasury_id',$params['treasury_id']);
        }
        $payment_vouchers = $query_payment_vouchers->sum('amount');

        $query_multi_vouchers = DB::table('multi_voucher_d')
            ->leftjoin('multi_voucher_m' , 'multi_voucher_d.multi_voucher_m_id' , '=' , 'multi_voucher_m.multi_voucher_m_id')
            ->where('multi_voucher_d.dis_type' , '=' , 1 )
            ->where('multi_voucher_m.action_date' , '=' , $params['date'] )
            ->where('multi_voucher_d_active' , '=' , 1)
            ->where('multi_voucher_active' , '=' , 1)
            ->selectRaw('
                multi_voucher_m.action_date ,
                sum( case when multi_voucher_d.voucher_type = 2 then multi_voucher_d.amount end ) as credit,
                sum( case when multi_voucher_d.voucher_type = 1 then multi_voucher_d.amount end ) as debit
            ');

        if(isset($params['branch_id'])){
            $query_multi_vouchers->where('multi_voucher_m.branch_id' , $params['branch_id']);
        }
        if(isset($params['treasury_id'])){
            $query_multi_vouchers->where('multi_voucher_d.dis_treasury_id',$params['treasury_id']);
        }
        $multi_vouchers = $query_multi_vouchers->first();
        $totals = [
            'net_cash'          => ($sales->paid_cash  - collect($all_n_creditor)->sum('paid_cash')) - $purchases->paid_cash ,
            'net_bank'          => $sales->paid_bank  - collect($all_n_creditor)->sum('paid_bank'),
            'net_terms'         => ($sales->term_sales - collect($all_n_creditor)->sum('term_sales')) - $purchases->term_purchase,
            'total_actions'     => $sales->paid_cash  - collect($all_n_creditor)->sum('paid_cash') + $sales->paid_bank  - collect($all_n_creditor)->sum('paid_bank') + $sales->term_sales - collect($all_n_creditor)->sum('term_sales') - $purchases->paid_cash - $purchases->term_purchase,
            'first'             => $params['first'] ,
            'total'             => $params['first'] + $sales->paid_cash  - collect($all_n_creditor)->sum('paid_cash') + $sales->paid_bank  - collect($all_n_creditor)->sum('paid_bank') + $sales->term_sales - collect($all_n_creditor)->sum('term_sales') - $purchases->paid_cash - $purchases->term_purchase,

        ];
        $net_sales = [
            'net_cash'          => $sales->paid_cash  - collect($all_n_creditor)->sum('paid_cash'),
            'net_bank'          => $sales->paid_bank  - collect($all_n_creditor)->sum('paid_bank'),
            'net_terms'         => $sales->term_sales - collect($all_n_creditor)->sum('term_sales'),
        ];
        
        $chart = [
            'sales'         => $sales->paid_cash + $sales->paid_bank  + $sales->term_sales,
            'purchases'     => $purchases->paid_cash + $purchases->term_purchase 
        ];
        $sales_query = DB::table('sales_invoice_m')
            ->leftjoin('daily_journal_m' , 'sales_invoice_m.daily_journal_m_id' , '=' , 'daily_journal_m.daily_journal_m_id')
            ->leftjoin('customers' , 'sales_invoice_m.customer_id' , '=' , 'customers.customer_id')
            ->leftjoin('sales_invoice_payments', 'sales_invoice_m.sales_invoice_m_id' , '=' , 'sales_invoice_payments.sales_invoice_m_id')
            ->leftjoin('sales_invoice_types' , 'sales_invoice_m.sales_invoice_type_id' , '=' , 'sales_invoice_types.sales_invoice_type_id')
            ->leftjoin('payment_methods', 'sales_invoice_payments.payment_type' , '=' , 'payment_methods.payment_method_id')
            ->leftjoin('branchs', 'sales_invoice_m.branch_id', '=', 'branchs.branch_id')
            ->where('sales_invoice_active' , 1)
            ->where('sales_invoice_date' , $params['date'])
            ->groupBy('sales_invoice_m.sales_invoice_m_id')
            ->selectRaw('
                sales_invoice_m.sales_invoice_m_id as m_id ,
                sales_invoice_m.daily_journal_m_id ,
                daily_journal_m.year_ser as journal_code ,
                sum(case when sales_invoice_types.sales_invoice_type_id = 1 then (sales_invoice_m.total_with_vat) end) as term_sales,
                sum(case when sales_invoice_payments.payment_type = 1 then
                case when sales_invoice_payments.treasury_id = ? then sales_invoice_payments.amount else 0 end
                end) as paid_cash,
                sum(case when sales_invoice_payments.payment_type = 2 then sales_invoice_payments.amount end) as paid_bank,
                sales_invoice_date ,

                sales_invoice_m.sales_invoice_type_id ,
                sales_invoice_types.sales_invoice_type_title_'.$params['lang'].' as type_title ,
                customers.name_'.$params['lang'].' as customer_name ,
                customer_invoice_type ,
                total_vat ,
                total_without_vat ,
                total_with_vat ,
                total_discount ,
                total_price_after_discount 
            ', [$params['treasury_id'] ?? null]);
            if(isset($params['branch_id'])){
                $sales_query->where('sales_invoice_m.branch_id' , $params['branch_id']);
            }
        $sales_invoices = $sales_query->get();

    ////////////////////////////////////////////////////////////////
    $purchase = DB::table('purchases_invoice_m')
        ->leftjoin('daily_journal_m' , 'purchases_invoice_m.daily_journal_m_id' , '=' , 'daily_journal_m.daily_journal_m_id')
        ->leftjoin('purchases_vendors' , 'purchases_invoice_m.purchases_vendor_id' , '=' , 'purchases_vendors.purchases_vendor_id')
        ->leftjoin('purchases_agents' , 'purchases_invoice_m.purchases_agent_id' , '=' , 'purchases_agents.purchases_agent_id')
        ->leftjoin('purchases_invoice_types' , 'purchases_invoice_m.purchases_invoice_type_id' , '=' , 'purchases_invoice_types.purchases_invoice_type_id')
        ->where('purchases_invoice_active' , 1)
        ->where('purchases_invoice_date' , $params['date'])
        ->groupBy('purchases_invoice_m.purchases_invoice_m_id')
        ->selectRaw('
                purchases_invoice_m.purchases_invoice_m_id as m_id ,
                purchases_invoice_m.purchases_invoice_type_id ,
                purchases_invoice_m.daily_journal_m_id ,
                daily_journal_m.year_ser as journal_code ,
                purchases_invoice_types.purchases_invoice_type_title_'.$params['lang'].' as purchases_invoice_type_name ,
                sum(case when purchases_invoice_m.purchases_invoice_type_id = 1 then (purchases_invoice_m.total_with_vat) end) as term_purchase,
                sum(case when purchases_invoice_m.purchases_invoice_type_id = 2 then (purchases_invoice_m.total_with_vat) end) as paid_cash,
                purchases_invoice_date ,
                purchases_vendors.name_'.$params['lang'].' as purchases_vendor_name ,
                purchases_agents.name_'.$params['lang'].' as purchases_agent_name ,
                purchases_invoice_m.branch_id ,
                total_vat ,
                total_without_vat ,
                total_with_vat ,
                current_total_vat ,
                current_total_without_vat ,
                current_total_with_vat ,
                purchases_invoice_active 
            ');
        if(isset($params['branch_id'])){
            $purchase->where('purchases_invoice_m.branch_id' , $params['branch_id']);
        }


    $purchase_invoices = $purchase->get();

    /////////////////////////////////////////////////////////////
    $notice_creditor = DB::table('notice_creditors_m')
        ->leftjoin('sales_invoice_m' , 'notice_creditors_m.sales_invoice_m_id' , '=' , 'sales_invoice_m.sales_invoice_m_id')
        ->leftjoin('notice_payments' , 'notice_creditors_m.notice_creditor_m_id' , '=' , 'notice_payments.notice_creditor_m_id')
        ->leftjoin('notice_creditors_d' , 'notice_creditors_m.notice_creditor_m_id' , '=' , 'notice_creditors_d.notice_creditor_m_id')
        ->leftjoin('daily_journal_m' , 'notice_creditors_m.daily_journal_m_id' , '=' , 'daily_journal_m.daily_journal_m_id')
        ->leftjoin('customers', 'notice_creditors_m.customer_id', '=', 'customers.customer_id')
        ->leftjoin('sales_invoice_types', 'notice_creditors_m.sales_invoice_type_id', '=', 'sales_invoice_types.sales_invoice_type_id')
        ->where('notice_creditor_active', 1)
        ->where('notice_creditors_m.invoice_date' , $params['date'])
        ->groupBy('notice_creditors_m.notice_creditor_m_id')
        ->selectRaw('
                notice_creditors_m.notice_creditor_m_id as m_id ,
                if(sales_invoice_m.sales_invoice_type_id = 1 , sum(notice_creditors_d.new_total_with_vat) , 0 ) as term_sales ,
                sum(case when notice_payments.payment_type = 1 then
                    case when notice_creditors_m.treasury_id = ? then notice_payments.amount else 0 end
                    end) as paid_cash,
                sum( case when notice_payments.payment_type = 2 then notice_payments.amount end ) as paid_bank ,
                sum(notice_creditors_d.new_total_with_vat) as total_with_vat ,
                notice_creditors_m.sales_invoice_m_id ,
                notice_creditors_m.branch_id ,
                notice_creditors_m.invoice_date ,
                notice_creditors_m.daily_journal_m_id ,
                daily_journal_m.year_ser as journal_code ,
                notice_creditors_m.customer_id ,
                customers.name_'.$params['lang'].' as customer_name ,
                sales_invoice_types.sales_invoice_type_id
            ', [$params['treasury_id'] ?? null]);

        if(isset($params['branch_id'])){
            $notice_creditor->where('notice_creditors_m.branch_id' , $params['branch_id']);
        }

    $notice_creditor_invoices = $notice_creditor->get();
        $report = [
            'sales'                         => $sales,
            'purchases'                     => $purchases,
            'creditor'                      => $n_creditor,
            'reciepts'                      => $reciept_vouchers,
            'payments'                      => $payment_vouchers,
            'credit_adjustments'            => $multi_vouchers->credit,
            'debit_adjustments'             => $multi_vouchers->debit,
            'net_sales_cash'                => $sales->paid_cash  - collect($all_n_creditor)->sum('paid_cash'),
            'first'                         => $params['first'] ,
            'totals'                        => $totals ,
            'chart'                         => $chart,
            'net_sales'                     => $net_sales,
            'notice_creditor_invoices'      => $notice_creditor_invoices ,
            'sales_invoices'                => $sales_invoices ,
            'purchase_invoices'             => $purchase_invoices 
        ];

        return $report;

    }
}
