<?php

namespace App\Classes\Sales;

use App\Models\Main\Setting;
use App\Models\Sales\Customer;
use DB;

class CustomerHelper
{
    function get_next_codes($date, $year, $branch)
    {
        $data['year_ser'] = intval(DB::table('customers')
                ->where('finance_year_id', $year)
                ->max('year_ser')) + 1;

        $data['month_ser'] = intval(DB::table('customers')
                ->where('finance_year_id', $year)
                ->max('month_ser')) + 1;

        $data['branch_ser'] = intval(DB::table('customers')
                ->where('branch_id', $branch)
                ->max('branch_ser')) + 1;

        return $data;
    }

    function can_edit_or_delete($id)
    {
        return true;
    }

    function generate_daily_journal($id)
    {
        return true;
    }
    function calculate_customer_points($customer_id , $invoice_value = null){
        $purchase_points_per_one    = boolval( Setting::get_main_setting_by_code('purchase_points_per_one')->value ?? 0 );
        $disscount_points_per_one   = boolval( Setting::get_main_setting_by_code('disscount_points_per_one')->value ?? 0 );
        $customer = Customer::get_customer($customer_id);
        if(isset($invoice_value)){
            $points = $invoice_value * $purchase_points_per_one;
            Customer::update_customer(['wallet_points' => $customer->wallet_points + $points], $customer_id);
        }
        return true;
    }
}
