<?php

namespace App\Classes\RealTime;
use Illuminate\Support\Facades\DB;
use Kreait\Firebase\Messaging\CloudMessage;

class NotificationHelper
{
    protected $messaging;
    protected $app;

    public function __construct($app = '')
    {
        if(strlen($app) > 0){
            $this->app = config($app);
            $factory = (new \Kreait\Firebase\Factory)->withServiceAccount($this->app);
            $this->messaging = $factory->createMessaging();
        }
    }
    function send_notifications($count = null , $params = null)
    {
        $tokens = DB::table('users')
            ->where('users.id', '!=', auth()->user()->id)
            ->pluck('fcm_token')->toArray();
        if(isset($params['type']) && $params['type'] == 'manufacturing'){
            $json_data = array(
                'notification'  => array(
                    "data"              => null,
                    'count'             =>  intval($count),
                    "sound"             => "default",
                ),
                "registration_ids"=> $tokens
            );
        }else{
            $json_data = array(
                'notification'  => array(
                    "data"              => null,
                    'booking_count'     =>  $count,
                    "sound"             => "default",
                ),
                "registration_ids"=> $tokens
            );
        }


            $data = json_encode($json_data);

            //FCM API end-point
            $url = 'https://fcm.googleapis.com/fcm/send';

            //api_key in Firebase Console -> Project Settings -> CLOUD MESSAGING -> Server key
            //$server_key = "AAAAEGpy50c:APA91bEgJ3zphsrmZ5CZEtqPtSpUiuB30AIrT6BY4J55uHwOW1xhmvgB0S9IsUAG-iarOZavKi_p4Spu6civXT2kXnJGu3UJKGVlMu37onqVlYg1cevlvMUkka3SIF0AYWqR2mzkpWAq";
            $server_key = "AAAAwDAhqhE:APA91bHd9OGJTLEpS2cpS2YQQvsv35sZTKcQ5ZqYxjVOxun3fl4caTb9hVyPqHL2Ig9k6KyJRAZASH6YgIOf4VNOxr8X_5ZsWH6O22FMQhfCtId3g6TJLe4q4oL-AKeBs1gRUOhC4dna";
            //header with content_type api keyAPA91bHd9OGJTLEpS2cpS2YQQvsv35sZTKcQ5ZqYxjVOxun3fl4caTb9hVyPqHL2Ig9k6KyJRAZASH6YgIOf4VNOxr8X_5ZsWH6O22FMQhfCtId3g6TJLe4q4oL
            $headers = array(
                'Content-Type:application/json',
                'Authorization:key='.$server_key
            );
            //CURL request to route notification to FCM connection server (provided by Google)
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            $result = curl_exec($ch);

            if ($result === FALSE) {
                die('Oops! FCM Send Error: ' . curl_error($ch));
            }
            curl_close($ch);
    }
    public function sendNotification($body , $token = null , $type = null)
    {
        if($token == null){
            $token = DB::table('users')->where('id',auth()->user()->id)->value('fcm_token');
        }
        $data = [
            'body'=>json_encode($body)
            ];
        if($type == "nfc_payment"){
            $noti_body = trans('main.new_nfc_payment');

        }elseif($type == "payment_success"){
            $noti_body = trans('main.payment_success');
        }elseif($type == "payment_failed"){
            $noti_body = trans('main.payment_failed');
        }else{
            $noti_body = trans('main.new_notification');
        }

        $message = CloudMessage::fromArray([
            'token' => $token,
            'notification' => [
                'title' => 'Qawaem POS',
                'body' => $noti_body,
            ],
            'data' => $data
            ]);
        try {
           return $this->messaging->send($message);

        } catch (\Throwable $e) {
            return $e->getMessage();
        }


    }
}
