<?php

namespace App\Classes\Purchases;
use App\Models\Purchases\PurchasesInvoice;
use App\Classes\Finance\DailyJournalHelper;
use App\Models\Main\Setting;
use App\Models\Purchases\ReturnPurchases;
use App\Models\Finance\DailyJournal;
use Illuminate\Support\Facades\DB;

class ReturnPurchasesHelper
{
    function get_next_codes($date, $year, $branch)
    {
        $data['year_ser'] = intval(DB::table('purchases_invoice_m')
                ->where('finance_year_id', $year)
                ->max('year_ser')) + 1;

        $data['month_ser'] = intval(DB::table('purchases_invoice_m')
                ->where('finance_year_id', $year)
                ->max('month_ser')) + 1;

        $data['branch_ser'] = intval(DB::table('purchases_invoice_m')
                ->where('branch_id', $branch)
                ->max('branch_ser')) + 1;

        return $data;
    }

    function can_edit_or_delete($id)
    {
        return true;
    }

    function generate_daily_journal($id)
    {

        $check = Setting::get_main_setting_by_code('return_purchase_journal')->value ?? false ;
        if(!$check){
            return array( true ,  '' ) ;
        }

        $main       = ReturnPurchases::get_return_purchase_m( $id ,'en' );
        $details    = ReturnPurchases::get_return_purchases_d( $id ,'en' );
        $return_purchase_account = Setting::get_main_setting_by_code('item_default_purchases_return')->value ?? false ;

        if(!isset($main->active) || $main->active == 0 ){
            DailyJournal::delete_daily_journal_m($main->daily_journal_m_id);
            return array( true ,  '' ) ;
        }

        $items      = [];
        $journal_data  = array(
            'finance_year_id'   => $main->finance_year_id  ,
            'branch_id'         => $main->branch_id ,
            'des'               => $main->description ,
            'journal_date'      => $main->action_date ,
            'document_id'       => $id ,
            'daily_type_id'     => 36 ,
            'auto_generated'    => 1 ,
            'journal_active'    => 1 ,
            'confirmed'         => 1
        );

        if($main->daily_journal_m_id > 0 ){
            $journal_data['daily_journal_id'] = $main->daily_journal_m_id;
        }


         $items[]   = array(
            'account_tree_id'   => $main->vendor_account_tree_id ,
            'cost_center_id'    => 0 ,
            'debit'             => 0   ,
            'credit'            => $main->returned_price ,
            'description'       => $main->description
        );

        foreach ( $details as $key => $detail ) {

            $items[]    = array(
                'account_tree_id'   => $return_purchase_account ?? 0 ,
                'cost_center_id'    => 0 ,
                'debit'             => $detail->returned_without_vat  ,
                'credit'            => 0,
                'description'       => $main->description
            );

            if($detail->returned_vat > 0 ){

                $tax = DB::table('taxes')->where('tax_id' , $detail->tax_percent_id)->first();
                
                $items[]    = array(
                    'account_tree_id'   => $tax->account_tree_id ?? 0 ,
                    'cost_center_id'    => 0 ,
                    'debit'             => $detail->returned_vat / $detail->returned_quantity  ,
                    'credit'            => 0,
                    'description'       => $main->description
                );
            }

        }


        $journal = (new DailyJournalHelper)->generate_journal($journal_data , $items );
        if($journal[0]){
            
            DB::table('return_purchases_m')
                ->where('return_purchase_m_id' , $id)
                ->update( ['daily_journal_m_id' => $journal[2]] );
            return $journal;

        }else{

            $response = [
               'check' => false,
               'data'  => $journal ,
               'msg'   => $journal[1]
            ];
            header('Content-Type: application/json; charset=utf-8; ');
            header('Access-Control-Allow-Origin:*');
            header('Access-Control-Allow-Headers:*');
            echo json_encode($response);
            die();

        }

        

    }
}
