<?php

namespace App\Classes\Purchases;

use App\Mail\SendMail;
use Illuminate\Support\Facades\DB;
use Illuminate\Mail\Mailable;
use Illuminate\Support\Facades\Mail;
use Spatie\PdfToImage\Pdf;

class PurchasesOrderHelper
{
    function get_next_codes($date, $year, $branch)
    {
        $data['year_ser'] = intval(DB::table('purchases_order_m')
                ->where('finance_year_id', $year)
                ->max('year_ser')) + 1;

        $data['month_ser'] = intval(DB::table('purchases_order_m')
                ->where('finance_year_id', $year)
                ->max('month_ser')) + 1;

        $data['branch_ser'] = intval(DB::table('purchases_order_m')
                ->where('branch_id', $branch)
                ->max('branch_ser')) + 1;

        return $data;
    }

    function can_edit_or_delete($id)
    {
        return true;
    }
    function check_approvement_permission()
    {
        $setting = DB::table('settings')->where('setting_code' , 'purchase_order_responsible')->first();
        $responsible_users  = json_decode($setting->value , true);
        if(in_array(auth()->user()->id , $responsible_users) || $setting->setting_active == 0){
            return 1;
        }else{
            return 0;
        }
    }
    function update_master_values($id)
    {
        $totals = DB::table('purchases_order_m')
            ->where('purchases_order_m.purchases_order_m_id', $id)
            ->join('purchases_order_d', 'purchases_order_m.purchases_order_m_id', '=', 'purchases_order_d.purchases_order_m_id')
            ->select('purchases_order_m.purchases_order_m_id',
                DB::raw('SUM(purchases_order_d.total_vat) as total_vat'),
                DB::raw('SUM(purchases_order_d.total_without_vat) as total_without_vat'),
                DB::raw('SUM(purchases_order_d.total_with_vat) as total_with_vat'))
            ->groupBy('purchases_order_m.purchases_order_m_id')
            ->first();

        return DB::table('purchases_order_m')
            ->where('purchases_order_m.purchases_order_m_id', $id)
            ->update([
                'total_vat'         => $totals->total_vat,
                'total_without_vat' => $totals->total_without_vat,
                'total_with_vat'    => $totals->total_with_vat,
            ]);
    }

    function send_to_responsible_users($id , $link_token = null , $client_id){
        $setting = DB::table('settings')->where('setting_code' , 'purchase_order_responsible')->first();
        $accept_link = url('/accept_purchase_order_mail/ar/ /'.$link_token.'?clientID='.$client_id);
        $decline_link = url('/decline_purchase_order_mail/ar/ /'.$link_token.'?clientID='.$client_id);
        $responsible_users  = json_decode($setting->value , true);
        $emails             = DB::table('users')->whereIn('id' , $responsible_users)->pluck('email')->toArray();
        $order = url('/print_purchases_order/'.$id.'?type=image&clientID='.request()->header('clientID'));

        $data = ['pdf'=>$order , 'accept_link'=>$accept_link , 'decline_link' => $decline_link];
        // return view('emails.purchase_order')->with('data',$data);
        foreach ($emails as $email) {
            // Send the email
            Mail::to($email)->send(new SendMail($data , 'emails.purchase_order'));
        }
    }
    // public function attachments_pdf($id)
    // {
    //     $files    = PurchasesOrder::get_purchases_order_files($id);
    //     $files                      = array_filter($files, function ($value) {
    //         return $value !== null;
    //     });
    //     $attachments_paths = [];
    //     $images = [];
    //     $images[] = url('/print_purchases_order/'.$id.'?type=image&clientID='.request()->header('clientID'));

    //     $file_paths = array_map(function ($path) {
    //         return ltrim($path, '/');
    //     }, $files);
    //     foreach ($file_paths as $file){
    //         $extension = pathinfo($file, PATHINFO_EXTENSION);
    //         $image_ext = ['jpg', 'jpeg', 'png', 'gif', 'webp']; // Add more as needed

    //         if(is_file($file) && strtolower(pathinfo($file, PATHINFO_EXTENSION)) === 'pdf'){
    //             $pdf = new Pdf($file);
    //             // Convert each page to a separate JPEG image
    //             $pages = $pdf->getNumberOfPages();
    //             for ($i = 1; $i <= $pages; $i++) {
    //                 $pdf->setPage($i);
    //                 $pdf->saveImage(public_path('upload/page_' . $i . '.jpg'));
    //                 $images[] = 'upload/page_' . $i . '.jpg';
    //             }
    //         }elseif(in_array(strtolower($extension), $image_ext)){
    //             $images[] = ($file);
    //         }else{
    //             $attachments_paths[] = $file;
    //         }
    //     }

    //     $pdf = DomFDPF::loadView('pdf', array('data'=>$images));
    //     $output = $pdf->save('upload/pdf_invoices/invoice_' . $id . '_' . date('Y-m-d H:i:s').'.pdf');
    //     // Storage::put(public_path('upload/invoice_' . $id . '_' . date('Y-m-d H:i:s').'.pdf'), $output);
    //     $attachments_paths[] = url('upload/pdf_invoices/invoice_' . $id . '_' . date('Y-m-d H:i:s').'.pdf');
    //     return $attachments_paths;
    // }
    function generate_daily_journal($id)
    {
        return true;
    }
}
