<?php

namespace App\Classes\Purchases;
use DB;

class PurchasesNoteHelper
{
    function get_next_codes($date, $year, $branch)
    {
        $data['year_ser'] = intval(DB::table('purchases_note_m')
                ->where('finance_year_id', $year)
                ->max('year_ser')) + 1;

        $data['month_ser'] = intval(DB::table('purchases_note_m')
                ->where('finance_year_id', $year)
                ->max('month_ser')) + 1;

        $data['branch_ser'] = intval(DB::table('purchases_note_m')
                ->where('branch_id', $branch)
                ->max('branch_ser')) + 1;

        return $data;
    }

    function can_edit_or_delete($id)
    {
        return true;
    }

    function update_master_values($id)
    {
        $totals = DB::table('purchases_note_m')
            ->where('purchases_note_m.purchases_note_m_id', $id)
            ->join('purchases_note_d', 'purchases_note_m.purchases_note_m_id', '=', 'purchases_note_d.purchases_note_m_id')
            ->select('purchases_note_m.purchases_note_m_id',
                DB::raw('SUM(purchases_note_d.total_vat) as total_vat'),
                DB::raw('SUM(purchases_note_d.total_without_vat) as total_without_vat'),
                DB::raw('SUM(purchases_note_d.total_with_vat) as total_with_vat'))
            ->groupBy('purchases_note_m.purchases_note_m_id')
            ->first();

        return DB::table('purchases_note_m')
            ->where('purchases_note_m.purchases_note_m_id', $id)
            ->update([
                'total_vat'         => $totals->total_vat,
                'total_without_vat' => $totals->total_without_vat,
                'total_with_vat'    => $totals->total_with_vat
            ]);
    }

    function generate_daily_journal($id)
    {
        return true;
    }
}
