<?php

namespace App\Classes\Inventory;
use DB;

class StockTransactionHelper
{
    function get_next_codes($date, $year, $branch)
    {
        $data['year_ser'] = intval(DB::table('stock_transaction_m')
                ->where('finance_year_id', $year)
                ->max('year_ser')) + 1;

        $data['month_ser'] = intval(DB::table('stock_transaction_m')
                ->where('finance_year_id', $year)
                ->max('month_ser')) + 1;

        $data['branch_ser'] = intval(DB::table('stock_transaction_m')
                ->where('branch_id', $branch)
                ->max('branch_ser')) + 1;

        return $data;
    }

    function update_master_values($id)
    {
        $totals = DB::table('stock_transaction_m')
            ->where('stock_transaction_m.stock_transaction_m_id', $id)
            ->leftjoin('stock_transaction_d', 'stock_transaction_m.stock_transaction_m_id', '=', 'stock_transaction_d.stock_transaction_m_id')
            ->select('stock_transaction_m.stock_transaction_m_id',
                DB::raw('SUM(stock_transaction_d.total_price) as total_price'))
            ->groupBy('stock_transaction_m.stock_transaction_m_id')
            ->first();

        return DB::table('stock_transaction_m')
            ->where('stock_transaction_m.stock_transaction_m_id', $id)
            ->update([
                'total_price' => $totals->total_price,
            ]);
    }

    function can_edit_or_delete($id)
    {
        return true;
    }

    function generate_daily_journal($id)
    {
        return true;
    }
}
