<?php
namespace App\Classes\General;

// use Closure;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Config;

class ClientIDCheck {

    protected $byInput = [
        'export_sales_invoice' ,
        'export_notice_creditor',
        'export_notice_debtor',
        'export_expense',
        'print_quotation',
        'print_proforma_invoice',
        'print_delivery_note',
        'print_sales_invoice',
        'print_purchases_order',
        'print_purchases_note',
        'print_purchases_invoice',
        'accept_purchase_order_mail',
        'decline_purchase_order_mail'
    ];

    public function check( $request )
    {
        $clients    = [ 'test', 'cseg' , 'csksa' , '701', '801', '802', '803', '804', '805', '806', '807' , '808', '810', '888', '999', '1001' , '1002', '1000' ,'waem' , '_db' , 'csksaold' , 'test' , '2000' , 'temp', 'local' , '1003' , '1004' , '1005' , '1006' , '3001' , '3002' , '3003', '3004' , '3005' , '3006' , '3007' , '3008' , '3009' , '3010' , '3011', '3012', '3013', '3014', '3015', '3016', '3017', '3018' , '3019', '3020' , '201'];
        $check      = false;



        if( in_array($request->segment(1), $this->byInput ) ){
            $clientID = $request->input('clientID') ?? session()->get('clientID') ?? 0;
        }elseif($request->segment(1) == 'api'){
            $clientID = request()->header('clientID');
        }else{
            $clientID = session()->get('clientID');
        }

        if ( strlen($clientID) >= 3 && ( in_array($clientID , $clients) || $clients > 1000  ) ) {

            Config::set('database.connections.mysql.database' , env('DB_PREFIX').$clientID );

            try {

                DB::reconnect();
                DB::connection()->getPdo();
                // DB::purge();
                $check = true;

            } catch (\Exception $e) {

            }

        }


        return $check;



    }
}
