<?php
namespace App\Classes\Finance;

use App\Classes\Finance\DailyJournalHelper;
use App\Models\Elevators\ElevatorsQuotation;
use App\Models\Sales\Customer;
use App\Models\Purchases\PurchasesVendor;
use App\Models\Finance\ReceiptVoucher;
use App\Models\Main\Bank;
use App\Models\Finance\Treasury;
use App\Models\Main\Setting;
use App\Models\Finance\DailyJournal;
use DB;


class ReceiptVoucherHelper {

	function can_edit_or_delete($id)
	{
	    // $account 	= DB::table('voucher_receipts')->where('voucher_receipt_id' , $id )->first();

		return true;
	}

    function update_related_contracts($id, $old = []){

        $details        = ReceiptVoucher::get_receipt_voucher_d($id ,'ar');
        $document_ids   = array_merge(collect($details)->pluck('document_id')->toArray(), $old);
        $current_payments = DB::table('quotations_payments')
            ->leftjoin('receipt_vouchers_d' , 'quotations_payments.payment_id' , '=' ,'receipt_vouchers_d.document_id')
            ->leftjoin('receipt_vouchers' , 'receipt_vouchers.receipt_voucher_id' , '=' ,'receipt_vouchers_d.receipt_voucher_m_id')
            ->whereIn('quotations_payments.payment_id' , $document_ids )
            ->groupBy('quotations_payments.payment_id')
            ->selectRaw('
                quotations_payments.payment_id ,
                sum( case when receipt_voucher_active = 1 then receipt_vouchers_d.amount end ) as amount
            ')
            ->get();
        foreach($current_payments as $current_payment){
            $payment    = DB::table('quotations_payments')->where('payment_id' , $current_payment->payment_id )->first();
            $remaining  = $payment->amount - $current_payment->amount;
            
            DB::table('quotations_payments')
                ->where('payment_id' , $current_payment->payment_id )
                ->update([
                    'paid'      => $current_payment->amount , 
                    'remaining' => $payment->amount - $current_payment->amount
                ]);

        }

    }

    function update_related($id , $old = []){
        $master  = ReceiptVoucher::get_receipt_voucher($id,'ar');

        if($master->voucher_type_id == 1 ){

        }elseif($master->voucher_type_id == 2 ){

        }

        $this->update_related_contracts($id , $old );

        return true;
    }

	function get_next_codes($date , $year , $branch){

		$data['year_ser'] = intval( DB::table('receipt_vouchers')
	        ->where('finance_year_id' , $year)
	        ->max('year_ser') ) + 1 ;

	    $data['month_ser'] = intval( DB::table('receipt_vouchers')
	        ->where('finance_year_id' , $year)
	        ->where('action_date' , 'like' , date("Y-m" , strtotime($date))."%" )
	        ->max('month_ser') ) + 1 ;

	    $data['branch_ser'] = intval( DB::table('receipt_vouchers')
	        ->where('branch_id' , $branch)
	        ->max('branch_ser') ) + 1 ;

	    return $data;
	}


	function generate_journal($id){

        $check = Setting::get_main_setting_by_code('receipt_voucher_journal')->value ?? false ;
        if(!$check){
            return array( true ,  '' ) ;
        }

        $main 		= ReceiptVoucher::get_receipt_voucher($id , 'en');
        $files      = ReceiptVoucher::get_attachs($id);

        if(!isset($main->active) || $main->active == 0 ){
            DailyJournal::delete_daily_journal_m($main->daily_journal_id);
            return array( true ,  '' ) ;
        }


        switch ($main->from_type) {
        	case '1':
        		$from_account = $main->from_account_tree_id;
    		break;
    		case '2':
        		$from_account = PurchasesVendor::get_purchases_vendor($main->purchases_vendor_id, 'en')->account_tree_id ?? 0;
    		break;
        	case '3':
        		$from_account = Customer::get_customer($main->from_customer_id, 'en')->account_tree_id ?? 0;
    		break;


        	default:
        		$from_account = 0;
    		break;
        }


        switch ($main->to_type) {
        	case '1':
        		$to_account = $main->to_account_tree_id;
    		break;
    		case '2':
        		$to_account = Treasury::get_treasury($main->to_treasury_id, 'en')->account_tree_id ?? 0;
    		break;
        	case '3':
        		$to_account = Bank::get_bank($main->to_bank_id , 'en')->account_tree_id ?? 0;
    		break;
    		case '4':
        		$to_account = Setting::get_main_setting_by_code('collection_Cheque')->value ;
    		break;

        	default:
        		$to_account = 0;
    		break;
        }


        $items 		= [];
        $journal_data  = array(
            'finance_year_id'   => $main->finance_year_id  ,
            'branch_id'         => $main->branch_id ,
            'des'           	=> $main->description ,
            'journal_date'      => $main->action_date ,
            'document_id'       => $id ,
            'daily_type_id'     => 18 ,
            'auto_generated'    => 1 ,
            'journal_active'    => 1 ,
            'confirmed'         => 1
        );

        if($main->daily_journal_id > 0 ){
            $journal_data['daily_journal_id'] = $main->daily_journal_id;
        }

        $items[]    = array(
            'account_tree_id'       => $to_account,
            'cost_center_id'        => 0 ,
            'debit'                 => $main->amount ,
            'credit'                => 0  ,
            'description'           => $main->description
        );

        $items[]   	= array(
            'account_tree_id'	=> $from_account ,
            'cost_center_id'	=> 0 ,
            'debit'				=> 0  ,
            'credit'			=> $main->amount  ,
            'description'		=> $main->description
        );



        $journal = (new DailyJournalHelper)->generate_journal($journal_data , $items , $files);

        if($journal[0]){

            DB::table('receipt_vouchers')
                ->where('receipt_voucher_id' , $id)
                ->update( ['daily_journal_id' => $journal[2]] );
            return $journal;

        }else{

            $response = [
               'check' => false,
               'data'  => $journal ,
               'msg'   => $journal[1]
            ];
            header('Content-Type: application/json; charset=utf-8; ');
            header('Access-Control-Allow-Origin:*');
            header('Access-Control-Allow-Headers:*');
            echo json_encode($response);
            die();

        }

    }


}
