<?php


namespace App\Classes\Finance;
use App\Models\Finance\ChequeOutgoing;
use DB;


class ChequeOutgoingHelper
{
    function get_next_codes($date , $year , $branch)
    {
        $data['year_ser'] = intval( DB::table('cheque_outgoings')
            ->where('finance_year_id' , $year)
            ->max('year_ser') ) + 1 ;

        $data['month_ser'] = intval( DB::table('cheque_outgoings')
            ->where('finance_year_id' , $year)
            ->where('due_date' , 'like' , date("Y-m" , strtotime($date))."%" )
            ->max('month_ser') ) + 1 ;

        $data['branch_ser'] = intval( DB::table('cheque_outgoings')
            ->where('branch_id' , $branch)
            ->max('branch_ser') ) + 1 ;

        return $data;
    }

    function can_edit_or_delete($id)
    {
        return true;
    }

    function generate_from_payment_vouchers($voucher_id)
    {
        $voucher = DB::table('payment_vouchers')
            ->where('payment_voucher_id' , $voucher_id )
            ->first();

        $codes  = $this->get_next_codes($voucher->action_date , $voucher->finance_year_id , $voucher->branch_id );
        $seed   = [
            'finance_year_id'   => $voucher->finance_year_id ,
            'branch_id'         => $voucher->branch_id ,
            'daily_journal_id'  => 0 ,
            'cheque_number'     => $voucher->cheque_number ,
            'branch_ser'        => $codes['branch_ser'] ,
            'month_ser'         => $codes['month_ser'] ,
            'year_ser'          => $codes['year_ser'] ,
            'customer_id'       => $voucher->to_customer_id ?? 0 ,
            'supplier_id'       => $voucher->to_supplier_id ?? 0 ,
            'voucher_id'        => $voucher_id ,
            'bank_id'           => $voucher->from_bank_id ,
            'amount'            => $voucher->amount ,
            'due_date'          => $voucher->due_date ,
            'cheque_status_id'  => 0 ,
            'add_user'          => auth()->user()->id
        ];

        ChequeOutgoing::add_cheque_outgoing($seed);
        return true;
    }

}