<?php

namespace App\Classes\Finance;
use DB;



class AccountTreeHelper {


	function get_next_account_tree2($id){

		if($id != 0 ){
	    	$parent 	= DB::table('account_tree')->where('account_tree_id' , $id )->first();
		}else{
			$parent = (object) array(
				'account_type' 	=> 1 ,
				'account_code' 	=> '' ,
				'level_chars'	=> 1 ,
				'account_nature'=> 1
			);
		}

	    if($parent->account_type != '1'){
	        return array('check' => 0 , 'msg' => "Can't add on this account" ) ;
	    }
	    $max 			= intval($parent->level_chars);
	    $childrens 		= DB::table('account_tree')->where('parent_id' , $id )->where('new_code','>',0)->orderBy('account_tree_id' , 'desc')->count();
	    $new_code 		= intval( $childrens ) + 1 ;
	    if(strlen($new_code) > $max ){
	        return array('check' => 0 , 'msg' => "Can't add more" ) ;
	    }
	    $new_code 		= $parent->account_code.str_pad( $new_code , $parent->level_chars , "0", STR_PAD_LEFT);
	    return array('check' => 1 , 'new_code' => $new_code , 'account_nature' => $parent->account_nature ?? 0 ) ;

	}

	
	function get_next_account_tree($id){

		if($id != 0 ){
	    	$parent 	= DB::table('account_tree')->where('account_tree_id' , $id )->first();
		}else{
			$parent = (object) array(
				'account_type' 	=> 1 , 
				'account_code' 	=> '' , 
				'level_chars'	=> 1 ,
				'account_nature'=> 1
			);
		}

	    if($parent->account_type != '1'){
	        return array('check' => 0 , 'msg' => "Can't add on this account" ) ;
	    }
	    $max 			= intval($parent->level_chars);
	    $childrens 		= DB::table('account_tree')->where('parent_id' , $id )->orderBy('account_tree_id' , 'desc')->first();
	    $new_code 		= intval( substr($childrens->account_code ?? '0' , strlen($parent->account_code)) ) + 1 ;
	    if(strlen($new_code) > $max ){
	        return array('check' => 0 , 'msg' => "Can't add more" ) ;
	    }
	    $new_code 		= $parent->account_code.str_pad( $new_code , $parent->level_chars , "0", STR_PAD_LEFT) ;
	    return array('check' => 1 , 'new_code' => $new_code , 'account_nature' => $parent->account_nature ) ;

	}


	function can_edit_or_delete($id)
	{
		
	    $account 	= DB::table('account_tree')->where('account_tree_id' , $id )->first();

        if( $account->account_type == 1 ){

            $children = DB::table('account_tree')->where('active' , 1 )->where('parent_id' , $id )->orderBy('account_tree_id' , 'desc')->count();
            if($children > 0){
                return false;
            }

        }else{

			$check = DB::table('daily_journal_d')->where('account_tree_id' , $id)->count();
            if($check > 0)
				return false;
           
        }

		return true;
	}

}