<?php

namespace App\Classes\Barbers;

use Illuminate\Support\Facades\DB;
use App\Classes\RealTime\NotificationHelper;
use App\Models\Main\Setting;
use App\Models\Sales\Customer;
use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\CloudMessage;

class BarberBookingHelper
{
    function checkBookingServiceBlocks($barber_id, $services, $barber_booking_date, $start_time)
    {
        $chairs_number = 1;
        $services = DB::table('items')->whereIn('item_id', $services)->get();
        $services_needed_blocks = collect($services)->sum('time_blocks');
        $services_needed_blocks = ceil($services_needed_blocks / 5);

        $services_time_blocks_ids = DB::table('b_times')
            ->where('time_id', '>=', $start_time)
            ->take($services_needed_blocks)
            ->pluck('time_id')
            ->toArray();

        $services_end_time = end($services_time_blocks_ids);


        foreach ($services_time_blocks_ids as $services_time_blocks_id) {

            $booking_counter = DB::table('barber_bookings')
                ->where('barber_booking_date', $barber_booking_date)
                ->where('barber_id', $barber_id)
                ->where('barber_booking_status', 1)
                ->where('barber_booking_active', 1)
                ->whereRaw('find_in_set(' . $services_time_blocks_id . ', time_blocks_ids)')
                ->count();

            if ($booking_counter >= $chairs_number) {
                return response()->json([
                    'check' => false,
                    'msg'   => trans('error.This Time Not Available For Selected Barber'),
                ], 200);
            }
        }
        // $next_barber_booking = DB::table('barber_bookings')
        //     ->where('barber_booking_date', $barber_booking_date)
        //     ->where('barber_id', $barber_id)
        //     ->where('barber_booking_status', 1)
        //     ->where('barber_booking_active', 1)
        //     ->where('start_time', '>=', $start_time)
        //     ->first();

        // if (!is_null($next_barber_booking)){
        //     foreach ($services_time_blocks_ids as $services_time_blocks_id){
        //         if (in_array($services_time_blocks_id, explode(',', $next_barber_booking->time_blocks_ids))){
        //             return response()->json([
        //                 'check' => false,
        //                 'msg'   => trans('error.This Services Needed Bigger Blocks Than Selected Block'),
        //             ], 200);
        //         }
        //     }
        // }

        // $barber_bookings = DB::table('barber_bookings')
        //     ->where('barber_booking_date', $barber_booking_date)
        //     ->where('barber_id', $barber_id)
        //     ->where('barber_booking_status', 1)
        //     ->where('barber_booking_active', 1)
        //     ->whereRaw('find_in_set('.$start_time.', time_blocks_ids)')
        //     ->get();

        // if (count($barber_bookings) > 0){
        //     return response()->json([
        //         'check' => false,
        //         'msg'   => trans('error.This Time Not Available For Selected Barber'),
        //     ], 200);
        // }

        return response()->json([
            'check' => true,
            'data'  => [],
            'msg'   => trans('main.The Block Available To This Services'),
        ], 200);
    }


    static function process_barberBooking_invoice($barber_booking_id, $m_id)
    {
        // 1. Update barber booking status
        DB::table('barber_bookings')
            ->where('barber_booking_id', $barber_booking_id)
            ->update([
                'has_invoice'           => 1,
                'b_invoice_id'          => $m_id,
                'barber_booking_status' => 4,
            ]);

        $barber_booking = DB::table('barber_bookings')
            ->where('barber_booking_id', $barber_booking_id)
            ->select('barber_customer_id', 'new_points', 'used_points', 'total_price')
            ->first();

        // 2. Update customer points and his invoices count
        DB::table('customers')
            ->where('customer_id', $barber_booking->barber_customer_id)
            ->increment('gift_total_invoices', 1);

        DB::table('customers')->where('customer_id', $barber_booking->barber_customer_id)->decrement('wallet_points', $barber_booking->used_points);
        DB::table('customers')->where('customer_id', $barber_booking->barber_customer_id)->increment('wallet_points', $barber_booking->new_points);


        // 3. Count active bookings without invoice today
        $count = DB::table('barber_bookings')
            ->where('barber_booking_active', 1)
            ->where('barber_booking_date', date('Y-m-d'))
            ->where('has_invoice', 0)
            ->count();

        (new NotificationHelper)->send_notifications($count);

        // 5. Check if customer has enough invoices for gift
        $gift_total_invoices = DB::table('customers')
            ->where('customer_id', $barber_booking->barber_customer_id)
            ->value('gift_total_invoices') ?? 0;

        $invoices_needed_for_gift = Setting::get_main_setting_by_code('invoices_needed_for_gift')->value ?? 0;
        $customer = Customer::find($barber_booking->barber_customer_id);

        // 6. If customer has enough invoices, send notification to their FCM token
        if ($gift_total_invoices >= $invoices_needed_for_gift) {
            $factory = (new Factory)->withServiceAccount(config_path('the_concept.json'));
            $messaging = $factory->createMessaging();
            $message = CloudMessage::fromArray([
                'token' => $customer->fcm_token,
                'notification' => [
                    'title' => trans('main.congratulations'),
                    'body'  => trans('main.you have reached the required number of invoices to claim the gift'),
                ],
            ]);

            $messaging->send($message);
        }
    }
}
