<?php

namespace App\Http\Responses\Main;

use Illuminate\Http\Resources\Json\JsonResource;

class UserResponse extends JsonResource
{
    public function toArray($request)
        {
            $lang = request()->header('lang') ?? 'en'; // fallback to query/body or 'en'

            return [
                'id'                    => $this->id,
                'name'                  => $this->name,
                'email'                 => $this->email,
                'username'              => $this->username,
                'phone'                 => $this->phone,
                'is_active'             => (bool) $this->is_active,
                'created_at'            => $this->created_at ? $this->created_at->format('Y-m-d H:i:s') : null,
                'updated_at'            => $this->updated_at ? $this->updated_at->format('Y-m-d H:i:s') : null,
            ];
        }

    /**
     * Custom response for collections and paginated collections.
     */
    public static function collection($resource)
    {
        // If it's paginated, use Laravel's pagination response format
        if ($resource instanceof \Illuminate\Contracts\Pagination\LengthAwarePaginator) {
            return[
                    'items' => parent::collection($resource),
                
                    'current_page' => $resource->currentPage(),
                    'last_page'    => $resource->lastPage(),
                    'per_page'     => $resource->perPage(),
                    'total'        => $resource->total(),
                    'first_page_url' => $resource->url(1),
                    'from' => $resource->firstItem(),
                    'last_page_url' => $resource->url($resource->lastPage()),
                    'links' => [],
                    'next_page_url' => $resource->nextPageUrl(),
                    'path' => $resource->path(),
                    'prev_page_url' => $resource->previousPageUrl(),
                    'to' => $resource->lastItem()
                
                ];
        }

        // If not paginated, just return the collection of resources
        return [
             parent::collection($resource),
        ];
    }



}
