<?php

namespace App\Http\Requests\Main;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UserRequest extends FormRequest {
    public function authorize(): bool {
        return true;
    }

    public function rules(): array {
        $userId = $this->route('user'); // assumes route like /users/{user}

        return [
            'name'             => 'required|string|max:255',
            'email'            => [
                'required',
                'email',
                'max:255',
                Rule::unique('users', 'email')->ignore($userId)
            ],
            'username'         => [
                'required',
                'string',
                'max:255',
                Rule::unique('users', 'username')->ignore($userId)
            ],
            'phone'         => [
                'required',
                'string',
                'max:255',
                Rule::unique('users', 'phone')->ignore($userId)
            ],
            'password'         => $this->isMethod('post') ? 'required|string|min:6' : 'nullable|string|min:6',
            'is_active'        => 'boolean',
        ];
    }
}
