<?php

namespace App\Http\Requests\Inventory;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class CategoryRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $categoryId = $this->route('category'); // assumes route like /categories/{category}

        return [
            'name_ar'   => [
                'required',
                'string',
                'max:255',
                Rule::unique('categories', 'name_ar')->ignore($categoryId)
            ],
            'name_en'   => [
                'required',
                'string',
                'max:255',
                Rule::unique('categories', 'name_en')->ignore($categoryId)
            ]
        ];
    }
}
