<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;

class SwitchDatabase
{
    public function handle(Request $request, Closure $next)
    {
        if (Auth::check()) {
            $clientId = Auth::user()->client_id;

            if ($clientId) {
                // Create a new database connection dynamically
                $databaseName = "cstesting_qaraterp" . $clientId; // example db name convention

                Config::set('database.connections.dynamic', [
                    'driver' => 'mysql',
                    'host' => env('DB_HOST', '127.0.0.1'),
                    'port' => env('DB_PORT', '3306'),
                    'database' => $databaseName,
                    'username' => env('DB_USERNAME', 'root'),
                    'password' => env('DB_PASSWORD', ''),
                    'charset' => 'utf8mb4',
                    'collation' => 'utf8mb4_unicode_ci',
                    'prefix' => '',
                    'strict' => true,
                    'engine' => null,
                ]);

                // Switch default connection to dynamic
                DB::purge('dynamic');
                DB::reconnect('dynamic');
                Config::set('database.default', 'dynamic');
            }
        }

        return $next($request);
    }
}
