<?php

namespace App\Http\Controllers\Api\Inventory;

use App\Http\Controllers\Api\BaseController;
use App\Models\Inventory\Item;
use App\Http\Requests\Inventory\ItemRequest;
use App\Repositories\Inventory\ItemRepository;
use App\Http\Responses\Inventory\ItemResponse;
use Illuminate\Http\Request;

class ItemController extends BaseController
{
    protected $repo;
    protected $data = [];

    public function __construct(ItemRepository $repo)
    {
        $this->repo = $repo;
    }

    public function index(Request $request)
    {
        $filter = [
            'word'          => $request['word'] ?? null,
            'is_active'     => $request['is_active'] ?? 1,
            'page'          => $request['page'] ?? 1,
            'perPage'       => $request['rows'] ?? 10,
        ];
        $this->data['items'] = ItemResponse::collection($this->repo->index($filter));
        return $this->sendResponse($this->data);
    }

    public function store(ItemRequest $request)
    {
        $this->data['item'] = new ItemResponse($this->repo->create($request->validated()));
        return $this->sendResponse($this->data, trans('main.add_success'));
    }

    public function show($id)
    {
        $this->data['item'] = new ItemResponse($this->repo->show($id));
        return $this->sendResponse($this->data);
    }

    public function update(ItemRequest $request, $id)
    {
        $item = Item::findOrFail($id);
        $item->update($request->validated());
        $this->data['item'] = new ItemResponse($item);
        return $this->sendResponse($this->data, trans('main.update_success'));
    }

    public function destroy($id)
    {
        $item = Item::findOrFail($id);
        $item->delete();
        return $this->sendResponse($this->data, trans('main.delete_success'));
    }
}
